/*
 * Copyright (c) 2014 NIBIO <http://www.nibio.no/>. 
 * 
 * This file is part of AppleScabModel.
 * AppleScabModel is free software: you can redistribute it and/or modify
 * it under the terms of the NIBIO Open Source License as published by 
 * NIBIO, either version 1 of the License, or (at your option) any
 * later version.
 * 
 * AppleScabModel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * NIBIO Open Source License for more details.
 * 
 * You should have received a copy of the NIBIO Open Source License
 * along with AppleScabModel.  If not, see <http://www.nibio.no/licenses/>.
 * 
 */

package no.nibio.vips.model.applescabmodel;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import static junit.framework.Assert.assertEquals;
import static junit.framework.Assert.fail;
import junit.framework.TestCase;
import no.nibio.vips.entity.ModelConfiguration;
import no.nibio.vips.entity.Result;
import no.nibio.vips.entity.WeatherObservation;
import no.nibio.vips.model.ConfigValidationException;
import no.nibio.vips.model.ModelExcecutionException;
import no.nibio.vips.util.CommonNamespaces;
import no.nibio.vips.util.WeatherObservationListException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;

/**
 *
 * @author treinar
 */
public class AppleScabModelTest extends TestCase {
    
    public AppleScabModelTest(String testName) {
        super(testName);
    }
    
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    // TODO add test methods here. The name must begin with 'test'. For example:
    // public void testHello() {}
    

    public void testAcceptance()
    {
        System.out.println("testAcceptance");
        try
        {
            Date start = new Date();
            AppleScabModel instance = new AppleScabModel();
            instance.setConfiguration(this.getConfiguration("/weatherData.json"));
            List<Result> results = null;
            try {
                results = instance.getResult();
            } catch (ModelExcecutionException ex) {
                Logger.getLogger(AppleScabModelTest.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("Model execution took " + (new Date().getTime() - start.getTime()) + " milliseconds");
            // Toggle this to print results when testing
            //if(results != null)
            if(false)
            {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                Collections.sort(results);
                System.out.println(
                            "Timestamp" + 
                            "\tAccumulatedTemperature" +
                            "\tAggregatedLeafWetness" +
                            "\tAggregatedTemperature" +
                            "\tAggregatedPrecipitation"
                            );
                for(Result result:results)
                {
                    if(result.getValue(instance.getModelId().toString(), AppleScabCalculations.ACCUMULATED_TEMPERATURE) != null)
                    {
                        System.out.println(
                                format.format(result.getValidTimeStart()) + 
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.ACCUMULATED_TEMPERATURE) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_LEAF_WETNESS) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_TEMPERATURE) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_PRECIPITATION)
                                );
                    }
                }
                Collections.reverse(results);
                
                System.out.println(
                            "Timestamp" + 
                            "\tAccumulatedMills" + 
                            "\tAscosporeMaturity" +
                            "\tTM" +
                            "\tBT" +
                            "\tRR"
                            );
                for(Result result:results)
                {
                    System.out.println(
                            format.format(result.getValidTimeStart()) + 
                            "\t" + result.getValue(instance.getModelId().toString(), AppleScabCalculations.ACCUMULATED_MILLS) + 
                            "\t" + result.getValue(instance.getModelId().toString(), AppleScabCalculations.ASCOSPORE_MATURITY) +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "TM") +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "BT") +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "RR") 
                            //+ result.getAllValues().toString()
                            );
                }

            }
        }
        catch(ConfigValidationException   ex)
        {
            fail("Exception: " + ex.getMessage());
        }
    }
    
    /**
     * NOT IN USE. Fallback responsibility has been passed on to data provider
     */
    public void notinuseTestAcceptanceWithLeafWetnessFallback()
    {
        System.out.println("testAcceptanceWithLeafWetnessFallback");
        try
        {
            Date start = new Date();
            AppleScabModel instance = new AppleScabModel();
            instance.setConfiguration(this.getConfiguration("/weatherDataWithoutBT.json"));
            List<Result> results = null;
            try {
                results = instance.getResult();
            } catch (ModelExcecutionException ex) {
                Logger.getLogger(AppleScabModelTest.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("Model execution took " + (new Date().getTime() - start.getTime()) + " milliseconds");
            // Toggle this to print results when testing
            //if(results != null)
            if(false)
            {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                Collections.sort(results);
                System.out.println(
                            "Timestamp" + 
                            "\tAccumulatedTemperature" +
                            "\tAggregatedLeafWetness" +
                            "\tAggregatedTemperature" +
                            "\tAggregatedPrecipitation"
                            );
                for(Result result:results)
                {
                    if(result.getValue(instance.getModelId().toString(), AppleScabCalculations.ACCUMULATED_TEMPERATURE)!= null)
                    {
                        System.out.println(
                                format.format(result.getValidTimeStart()) + 
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.ACCUMULATED_TEMPERATURE) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_LEAF_WETNESS) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_TEMPERATURE) +
                                "\t" + result.getValue(CommonNamespaces.NS_WEATHER, AppleScabCalculations.AGGREGATED_PRECIPITATION)
                                );
                    }
                }
                Collections.reverse(results);
                
                System.out.println(
                            "Timestamp" + 
                            "\tAccumulatedMills" + 
                            "\tAscosporeMaturity" +
                            "\tTM" +
                            "\tBT" +
                            "\tRR"
                            );
                for(Result result:results)
                {
                    System.out.println(
                            format.format(result.getValidTimeStart()) + 
                            "\t" + result.getValue(instance.getModelId().toString(), AppleScabCalculations.ACCUMULATED_MILLS) + 
                            "\t" + result.getValue(instance.getModelId().toString(), AppleScabCalculations.ASCOSPORE_MATURITY) +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "TM") +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "BT") +
                            "\t" + result.getValue(CommonNamespaces.NS_WEATHER, "RR") 
                                    //+ result.getAllValues().toString()
                            );
                }

            }
        }
        catch(ConfigValidationException   ex)
        {
            fail("Exception: " + ex.getMessage());
        }
    }
    
    public void testGetAccumulatedTemperature()
    {
        System.out.println("testGetAccumulatedTemperature");
        try
        {
            AppleScabModel instance = new AppleScabModel();
            instance.setConfiguration(this.getConfiguration("/weatherData.json"));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Oslo"));
            cal.set(2012, Calendar.JULY, 1, 0, 0, 0);
            cal.set(Calendar.MILLISECOND,0);
            assertEquals(842.8150416666666, instance.getAccumulatedTemperature(cal.getTime()));
        }
        catch(ConfigValidationException  | WeatherObservationListException ex)
        {
            fail("Exception: " + ex.getMessage());
        }
    }
    
    public void testcalculateAscosporeMaturity()
    {
        System.out.println("testcalculateAscosporeMaturity");
        try
        {
            AppleScabModel instance = new AppleScabModel();
            instance.setConfiguration(this.getConfiguration("/weatherData.json"));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Oslo"));
            cal.set(2012, Calendar.MAY, 1, 0, 0, 0);
            cal.set(Calendar.MILLISECOND,0);
            assertEquals(9d, instance.calculateAscosporeMaturity(cal.getTime()));
            cal.set(Calendar.DATE, 15);
            assertEquals(42d, instance.calculateAscosporeMaturity(cal.getTime()));
            cal.set(Calendar.MONTH, Calendar.JULY);
            assertEquals(100d, instance.calculateAscosporeMaturity(cal.getTime()));
        }
        catch(ConfigValidationException  | WeatherObservationListException ex)
        {
            fail("Exception: " + ex.getMessage());
        }
    }
    
    public void testGetDescription()
    {
        System.out.println("testGetDescription");
        AppleScabModel instance = new AppleScabModel();
        instance.getModelDescription();
    }
    
    private ModelConfiguration getConfiguration(String fileName)
    {
        try {
            ModelConfiguration config = new ModelConfiguration();
            config.setModelId(AppleScabModel.MODEL_ID.toString());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Oslo"));
            cal.set(2012, Calendar.MARCH, 25, 0, 0, 0);
            cal.set(Calendar.MILLISECOND, 0);
            //config.setConfigParameter("startDateAscosporeMaturity", cal.getTime());
            config.setConfigParameter("startDateAscosporeMaturity", "2012-03-25");
            config.setConfigParameter("timeZone", cal.getTimeZone().getID());
            BufferedInputStream inputStream = new BufferedInputStream(this.getClass().getResourceAsStream(fileName));
            JsonFactory f = new MappingJsonFactory();
            JsonParser jp = f.createJsonParser(inputStream);
            JsonNode all = jp.readValueAsTree();
            List<WeatherObservation> observations = new ArrayList<>();
            ObjectMapper mapper = new ObjectMapper();

            Date firstDate = null;
            Date lastDate = null;
            if(all.isArray())
            {
                for(JsonNode node : all){
                    Date timeMeasured = (Date)mapper.convertValue(node.get("timeMeasured").asText(), new TypeReference<Date>(){});
                    if(firstDate == null || firstDate.compareTo(timeMeasured) > 0)
                    {
                        firstDate = timeMeasured;
                    }
                    if(lastDate == null || lastDate.compareTo(timeMeasured) < 0)
                    {
                        lastDate = timeMeasured;
                    }
                    //System.out.println(node.toString());
                    WeatherObservation observation = new WeatherObservation();
                    observation.setTimeMeasured(timeMeasured);
                    observation.setLogIntervalId(node.get("logIntervalId").asInt());
                    observation.setElementMeasurementTypeId(node.get("elementMeasurementTypeId").asText());
                    observation.setValue(node.get("value").asDouble());
                    observations.add(observation);
                }

            }
            else
            {
                fail("Data input from file is not a JSON array");
            }
            config.setConfigParameter("observations", observations);

            
            return config;
        } catch (IOException ex) {
            return null;
        } 
    }
    
    public void testMillsTable()
    {
        System.out.println("testMillsTable");
        MillsTable table = new MillsTable();
        Double expResult = 2d;
        assertEquals(2d, table.getMillsValue(0d, 1));
        assertEquals(3d, table.getMillsValue(3d, 1));
        assertEquals(9d, table.getMillsValue(10d, 1));
        assertEquals(13d, table.getMillsValue(13.5, 1));
        assertEquals(11d, table.getMillsValue(11.6, 2));
        assertEquals(0d, table.getMillsValue(27d, 1));
        assertEquals(0d, table.getMillsValue(27d, 2));
        assertEquals(0d, table.getMillsValue(50d, 2));
    }
    
    
}
