/*
 * Copyright (c) 2014 NIBIO <http://www.nibio.no/>. 
 * 
 * This file is part of AppleScabModel.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 * 
 */
package no.nibio.vips.model.applescabmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @copyright 2013 <a href="http://www.nibio.no/">NIBIO</a>
 * @author Tor-Einar Skog <tor-einar.skog@nibio.no>
 */
public class AscosporeMaturityTable {
    private static final Map<Double, Double> maturityTable;
    
    /**
     * 
     * @param accumulatedTemperature Accumulation of 
     * daily temperature &gt; 0 degrees Celcius over a given period
     * @return 
     */
    public Double getAscosporeMaturity(Double accumulatedTemperature)
    {
        Double ascosporeMaturity;
        if ( accumulatedTemperature > 0 )
        {
            if ( accumulatedTemperature < 600 )
            {
                Double roundedTemperature = Math.floor(accumulatedTemperature/10) * 10;
                ascosporeMaturity = maturityTable.get(roundedTemperature);
            } 
            else
            {
                ascosporeMaturity = 100d;
            }
        }
        else
        {
            ascosporeMaturity = 0d;
        }
        return ascosporeMaturity;
    }
    
    static {
        Map<Double, Double> aMap = new HashMap();
        /**
         * These were generated from NIBIO's VIPS database from this query:
         * SELECT 'aMap.put(' || temperatur ||  'd,' || akkumulert_sporemodning || 'd);' FROM askosporemodning;
         */
        aMap.put(0d,1d);
        aMap.put(10d,1d);
        aMap.put(20d,1d);
        aMap.put(30d,1d);
        aMap.put(40d,2d);
        aMap.put(50d,2d);
        aMap.put(60d,3d);
        aMap.put(70d,4d);
        aMap.put(80d,5d);
        aMap.put(90d,6d);
        aMap.put(100d,7d);
        aMap.put(110d,8d);
        aMap.put(120d,9d);
        aMap.put(130d,12d);
        aMap.put(140d,14d);
        aMap.put(150d,16d);
        aMap.put(160d,19d);
        aMap.put(170d,21d);
        aMap.put(180d,25d);
        aMap.put(190d,28d);
        aMap.put(200d,31d);
        aMap.put(210d,35d);
        aMap.put(220d,39d);
        aMap.put(230d,42d);
        aMap.put(240d,46d);
        aMap.put(250d,50d);
        aMap.put(260d,54d);
        aMap.put(270d,58d);
        aMap.put(280d,62d);
        aMap.put(290d,66d);
        aMap.put(300d,70d);
        aMap.put(310d,73d);
        aMap.put(320d,76d);
        aMap.put(330d,79d);
        aMap.put(340d,82d);
        aMap.put(350d,84d);
        aMap.put(360d,87d);
        aMap.put(370d,89d);
        aMap.put(380d,90d);
        aMap.put(390d,92d);
        aMap.put(400d,93d);
        aMap.put(410d,95d);
        aMap.put(420d,96d);
        aMap.put(430d,96d);
        aMap.put(440d,97d);
        aMap.put(450d,98d);
        aMap.put(460d,98d);
        aMap.put(470d,99d);
        aMap.put(480d,99d);
        aMap.put(490d,99d);
        aMap.put(500d,99d);
        aMap.put(510d,100d);
        aMap.put(520d,100d);
        aMap.put(530d,100d);
        aMap.put(540d,100d);
        aMap.put(550d,100d);
        aMap.put(560d,100d);
        aMap.put(570d,100d);
        aMap.put(580d,100d);
        aMap.put(590d,100d);
        aMap.put(600d,100d);

        maturityTable = Collections.unmodifiableMap(aMap);
    }
    
}
