/*
 * Copyright (c) 2015 NIBIO <http://www.nibio.no/>. 
 * 
 * This file is part of VIPSLogic.
 * VIPSLogic is free software: you can redistribute it and/or modify
 * it under the terms of the NIBIO Open Source License as published by 
 * NIBIO, either version 1 of the License, or (at your option) any
 * later version.
 * 
 * VIPSLogic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * NIBIO Open Source License for more details.
 * 
 * You should have received a copy of the NIBIO Open Source License
 * along with VIPSLogic.  If not, see <http://www.nibio.no/licenses/>.
 * 
 */

package no.nibio.vips.logic.messaging;

import com.webcohesion.enunciate.metadata.Facet;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

/**
 * @copyright 2015 <a href="http://www.bioforsk.no/">Bioforsk</a>
 * @author Tor-Einar Skog <tor-einar.skog@bioforsk.no>
 */
@Facet("restricted")
@Path("/")
public interface UniversalMessagingServiceClient {

   @POST
   @Path("vips_msg_ws_01/rest/send_vips_msg")
   @Consumes("application/json;charset=UTF-8")
   @Produces("application/json;charset=UTF-8")
   public Response sendMessage(UniversalMessage universalMessage);
   
   @POST
   @Path("vips_msg_ws_01/rest/send_vips_msg")
   @Consumes("application/json;charset=UTF-8")
   @Produces("application/json;charset=UTF-8")
   public Response sendMessage(String universalMessage);
}
