/*
 * Copyright (c) 2014 NIBIO <http://www.nibio.no/>. 
 * 
 * This file is part of VIPSLogic.
 * VIPSLogic is free software: you can redistribute it and/or modify
 * it under the terms of the NIBIO Open Source License as published by 
 * NIBIO, either version 1 of the License, or (at your option) any
 * later version.
 * 
 * VIPSLogic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * NIBIO Open Source License for more details.
 * 
 * You should have received a copy of the NIBIO Open Source License
 * along with VIPSLogic.  If not, see <http://www.nibio.no/licenses/>.
 * 
 */

package no.nibio.vips.logic;

import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

/**
 * Responsible for adding REST resources
 * @copyright 2016 {@link http://www.nibio.no NIBIO}
 * @author Tor-Einar Skog <tor-einar.skog@nibio.no>
 */
@ApplicationPath("/rest/")
public class VIPSLogicApplication extends Application
{
    @Override
    public Set<Class<?>> getClasses() {
        Set<Class<?>> resources = new java.util.HashSet<>();
        //addRestResourceClasses(resources);
        addRestResourceClassesManually(resources);
        return resources;
    }

    /**
     * Handmade because NetBeans doesn't discover the services that are implementations
     * of service interfaces. And it adds the interfaces it finds, which do not work
     * @param resources 
     */
    private void addRestResourceClassesManually(Set<Class<?>> resources) {
        resources.add(no.nibio.vips.logic.service.LogicService.class);
        resources.add(no.nibio.vips.logic.service.VIPSMobileService.class);
        resources.add(no.nibio.vips.logic.modules.barleynetblotch.BarleyNetBlotchModelService.class);
        resources.add(no.nibio.vips.logic.modules.wheatleafblotch.WheatLeafBlotchModelService.class);
        resources.add(no.nibio.vips.logic.modules.roughage.RoughageService.class);
        resources.add(no.nibio.vips.observationdata.ObservationDataService.class);
        resources.add(no.nibio.vips.logic.messaging.sms.SMSHandlingService.class);
        resources.add(no.nibio.vips.logic.modules.applefruitmoth.AppleFruitMothService.class);
        resources.add(no.nibio.vips.logic.service.ObservationService.class);
        resources.add(no.nibio.vips.logic.service.ModelFormService.class);
        resources.add(no.nibio.vips.logic.service.GrowthStageService.class);
        
        resources.add(no.nibio.vips.logic.service.JacksonConfig.class);
        //resources.add(no.nibio.vips.logic.service.JSONBConfig.class);
        //resources.add(no.nibio.vips.coremanager.service.ManagerResourceImpl.class);
    }
    
    /**
     * Do not modify addRestResourceClasses() method.
     * It is automatically re-generated by NetBeans REST support to populate
     * given list with all resources defined in the project.
     */
    private void addRestResourceClasses(Set<Class<?>> resources) {
        resources.add(no.nibio.vips.logic.messaging.sms.SMSHandlingService.class);
        resources.add(no.nibio.vips.logic.modules.applefruitmoth.AppleFruitMothService.class);
        resources.add(no.nibio.vips.logic.modules.barleynetblotch.BarleyNetBlotchModelService.class);
        resources.add(no.nibio.vips.logic.modules.roughage.RoughageService.class);
        resources.add(no.nibio.vips.logic.modules.wheatleafblotch.WheatLeafBlotchModelService.class);
        resources.add(no.nibio.vips.logic.service.GrowthStageService.class);
        resources.add(no.nibio.vips.logic.service.JSONBConfig.class);
        resources.add(no.nibio.vips.logic.service.JacksonConfig.class);
        resources.add(no.nibio.vips.logic.service.LogicService.class);
        resources.add(no.nibio.vips.logic.service.ModelFormService.class);
        resources.add(no.nibio.vips.logic.service.ObservationService.class);
        resources.add(no.nibio.vips.logic.service.VIPSMobileService.class);
        resources.add(no.nibio.vips.observationdata.ObservationDataService.class);
    }
}