/*
 * Copyright (c) 2015 NIBIO <http://www.nibio.no/>. 
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

package no.nibio.vips.logic.util;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @copyright 2015 <a href="http://www.nibio.no/">NIBIO</a>
 * @author Tor-Einar Skog <tor-einar.skog@nibio.no>
 */
public class DOMUtils {

    public static synchronized String getNodeValue(String tagName, NodeList nodes ) {
        for ( int x = 0; x < nodes.getLength(); x++ ) {
            Node node = nodes.item(x);
            if (node.getNodeName().equalsIgnoreCase(tagName)) {
                NodeList childNodes = node.getChildNodes();
                for (int y = 0; y < childNodes.getLength(); y++ ) {
                    Node data = childNodes.item(y);
                    if ( data.getNodeType() == Node.TEXT_NODE )
                        return data.getNodeValue();
                }
            }
        }
        return "";
    }
    
    public static synchronized Node getNode(String tagName, NodeList nodes) {
        for ( int x = 0; x < nodes.getLength(); x++ ) {
            Node node = nodes.item(x);
            if (node.getNodeName().equalsIgnoreCase(tagName)) {
                return node;
            }
        }

        return null;
    }
    
    public static synchronized String getNodeAttr(String tagName, String attrName, NodeList nodes ) {
       for ( int x = 0; x < nodes.getLength(); x++ ) {
           Node node = nodes.item(x);
           if (node.getNodeName().equalsIgnoreCase(tagName)) {
               return node.getAttributes().getNamedItem(attrName).getNodeValue();
               /*NodeList childNodes = node.getChildNodes();
               for (int y = 0; y < childNodes.getLength(); y++ ) {
                   Node data = childNodes.item(y);
                   if ( data.getNodeType() == Node.ATTRIBUTE_NODE ) {
                       if ( data.getNodeName().equalsIgnoreCase(attrName) )
                           return data.getNodeValue();
                   }
               }*/
           }
       }

       return "";
   }   
    
}
