/*
 * Copyright (c) 2014 NIBIO <http://www.nibio.no/>. 
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

package no.nibio.vips.logic.entity;

import java.io.Serializable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @copyright 2013 <a href="http://www.nibio.no/">NIBIO</a>
 * @author Tor-Einar Skog <tor-einar.skog@nibio.no>
 */
@Entity
@Table(name = "user_point_of_interest")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "UserPointOfInterest.findAll", query = "SELECT u FROM UserPointOfInterest u"),
    @NamedQuery(name = "UserPointOfInterest.findByPointOfInterestId", query = "SELECT u FROM UserPointOfInterest u WHERE u.userPointOfInterestPK.pointOfInterestId = :pointOfInterestId"),
    @NamedQuery(name = "UserPointOfInterest.findByUserId", query = "SELECT u FROM UserPointOfInterest u WHERE u.userPointOfInterestPK.userId = :userId")})
public class UserPointOfInterest implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected UserPointOfInterestPK userPointOfInterestPK;
    @JoinColumn(name = "point_of_interest_id", referencedColumnName = "point_of_interest_id", insertable = false, updatable = false)
    @ManyToOne(optional = false)
    private PointOfInterest pointOfInterest;

    public UserPointOfInterest() {
    }

    public UserPointOfInterest(UserPointOfInterestPK userPointOfInterestPK) {
        this.userPointOfInterestPK = userPointOfInterestPK;
    }

    public UserPointOfInterest(int pointOfInterestId, int userId) {
        this.userPointOfInterestPK = new UserPointOfInterestPK(pointOfInterestId, userId);
    }

    public UserPointOfInterestPK getUserPointOfInterestPK() {
        return userPointOfInterestPK;
    }

    public void setUserPointOfInterestPK(UserPointOfInterestPK userPointOfInterestPK) {
        this.userPointOfInterestPK = userPointOfInterestPK;
    }

    public PointOfInterest getPointOfInterest() {
        return pointOfInterest;
    }

    public void setPointOfInterest(PointOfInterest pointOfInterest) {
        this.pointOfInterest = pointOfInterest;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (userPointOfInterestPK != null ? userPointOfInterestPK.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof UserPointOfInterest)) {
            return false;
        }
        UserPointOfInterest other = (UserPointOfInterest) object;
        if ((this.userPointOfInterestPK == null && other.userPointOfInterestPK != null) || (this.userPointOfInterestPK != null && !this.userPointOfInterestPK.equals(other.userPointOfInterestPK))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "no.nibio.vips.logic.entity.UserPointOfInterest[ userPointOfInterestPK=" + userPointOfInterestPK + " ]";
    }

}
