/*
 * Copyright (c) 2014 NIBIO <http://www.nibio.no/>. 
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

package no.nibio.vips.logic.entity;

import java.io.Serializable;
import java.util.Set;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * @copyright 2014 <a href="http://www.nibio.no/">NIBIO</a>
 * @author Tor-Einar Skog <tor-einar.skog@nibio.no>
 */
@Entity
@Table(name = "observation_method")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "ObservationMethod.findAll", query = "SELECT o FROM ObservationMethod o"),
    @NamedQuery(name = "ObservationMethod.findByObservationMethodId", query = "SELECT o FROM ObservationMethod o WHERE o.observationMethodId = :observationMethodId")})
public class ObservationMethod implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 63)
    @Column(name = "observation_method_id")
    private String observationMethodId;
    

    public ObservationMethod() {
    }

    public ObservationMethod(String observationMethodId) {
        this.observationMethodId = observationMethodId;
    }

    public String getObservationMethodId() {
        return observationMethodId;
    }

    public void setObservationMethodId(String observationMethodId) {
        this.observationMethodId = observationMethodId;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (observationMethodId != null ? observationMethodId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof ObservationMethod)) {
            return false;
        }
        ObservationMethod other = (ObservationMethod) object;
        if ((this.observationMethodId == null && other.observationMethodId != null) || (this.observationMethodId != null && !this.observationMethodId.equals(other.observationMethodId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "no.nibio.vips.logic.entity.ObservationMethod[ observationMethodId=" + observationMethodId + " ]";
    }

}
